% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-peaks.R
\name{find_peaks}
\alias{find_peaks}
\title{Find local maxima or global maximum (peaks)}
\usage{
find_peaks(x, ignore_threshold = 0, span = 3, strict = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the size
threshold below which peaks will be ignored, or a negative value >= -1,
to ignore peaks above a threshold. These values are relative to the range
of \code{x}.}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 3, meaning that a peak is bigger than both of
its neighbors. \code{span = NULL} extends the span to the whole length of
\code{x}.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}
}
\value{
A vector of logical values. Values that are TRUE correspond to local
  peaks in vector \code{x} and can be used to extract the rows corresponding
  to peaks from a data frame.
}
\description{
This method finds peaks (local maxima) in a vector, using a user selectable
span and size threshold relative to the tallest peak (global maximum).
}
\details{
This function is a wrapper built onto function
  \code{\link[splus2R]{peaks}} from \pkg{splus2R} and handles non-finite
  (including NA) values differently than \code{peaks}, instead of giving an
  error when \code{na.rm = FALSE} and \code{x} contains \code{NA} values,
  \code{NA} values are replaced with the smallest finite value in \code{x}.
  \code{span = NULL} is treated as a special case and returns \code{max(x)}.
}
\note{
The default for parameter \code{strict} is \code{FALSE} in functions
  \code{peaks()} and \code{find_peaks()}, as in \code{stat_peaks()} and in
  \code{stat_valleys()}, while the default in \code{\link[splus2R]{peaks}}
  is \code{strict = TRUE}.
}
\examples{
# lynx is a time.series object
lynx_num.df <-
  try_tibble(lynx,
             col.names = c("year", "lynx"),
             as.numeric = TRUE) # years -> as numeric

which(find_peaks(lynx_num.df$lynx, span = 31))
lynx_num.df[find_peaks(lynx_num.df$lynx, span = 15), ]
lynx_num.df[find_peaks(lynx_num.df$lynx, span = NULL), ]
lynx_num.df[find_peaks(lynx_num.df$lynx,
                       span = 31,
                       ignore_threshold = 0.75), ]

lynx_datetime.df <-
   try_tibble(lynx,
              col.names = c("year", "lynx")) # years -> POSIXct

which(find_peaks(lynx_datetime.df$lynx, span = 31))
lynx_datetime.df[find_peaks(lynx_datetime.df$lynx, span = 31), ]
lynx_datetime.df[find_peaks(lynx_datetime.df$lynx,
                            span = 31,
                            ignore_threshold = 0.75), ]

}
\seealso{
\code{\link[splus2R]{peaks}}
}
