% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-eq-label.R
\name{coefs2poly_eq}
\alias{coefs2poly_eq}
\title{Format a polynomial as an equation}
\usage{
coefs2poly_eq(
  coefs,
  coef.digits = 3L,
  coef.keep.zeros = TRUE,
  decreasing = getOption("ggpmisc.decreasing.poly.eq", FALSE),
  eq.x.rhs = "x",
  lhs = "y~`=`~",
  output.type = "expression",
  decimal.mark = "."
)
}
\arguments{
\item{coefs}{numeric Terms always sorted by increasing powers.}

\item{coef.digits}{integer}

\item{coef.keep.zeros}{logical This flag refers to trailing zeros.}

\item{decreasing}{logical It specifies the order of the terms in the
returned character string; in increasing (default) or decreasing powers.}

\item{eq.x.rhs}{character}

\item{lhs}{character}

\item{output.type}{character One of "expression", "latex", "tex", "text",
"tikz", "markdown".}

\item{decimal.mark}{character}
}
\value{
A \code{character} string.
}
\description{
Uses a vector of coefficients from a model fit of a polynomial to build
the fitted model equation with embedded coefficient estimates.
}
\note{
Terms with zero-valued coefficients are dropped from the polynomial.
}
\examples{
coefs2poly_eq(c(1, 2, 0, 4, 5, 2e-5))
coefs2poly_eq(c(1, 2, 0, 4, 5, 2e-5), output.type = "latex")
coefs2poly_eq(0:2)
coefs2poly_eq(0:2, decreasing = TRUE)
coefs2poly_eq(c(1, 2, 0, 4, 5), coef.keep.zeros = TRUE)
coefs2poly_eq(c(1, 2, 0, 4, 5), coef.keep.zeros = FALSE)

}
