% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-point-linked.r
\name{geom_point_s}
\alias{geom_point_s}
\title{Points linked by a segment}
\usage{
geom_point_s(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  nudge_x = 0,
  nudge_y = 0,
  arrow = NULL,
  add.segments = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
  are three types of arguments you can use here:

  \itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
  \code{colour = "red"} or \code{size = 3}. \item Other arguments to the
  layer, for example you override the default \code{stat} associated with the
  layer. \item Other arguments passed on to the stat. }}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{add.segments}{logical Display connecting segments or arrows between
original positions and displaced ones if both are available.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A plot layer instance.
}
\description{
The \code{"point_s"} geom provides a superset of the capabilities of geom
\code{"point"} from package 'ggplot2' by allowing plotting of segments
joining the original position of displaced observations to their current
potition rendered as points or graphic symbols. Displacements by position
functions from packages 'ggpp' and 'ggrepel' are supported.
}
\details{
The plotting of segments is similar in idea at that available in
  \code{\link[ggrepel]{geom_text_repel}} and relies on position functions
  that rename instead of removing the original original \code{x} and \code{y}
  coordinates from the \code{data} object.

  By default this geom uses \code{\link{position_nudge_center}} which is backwards
  compatible with \code{\link[ggplot2]{position_nudge}} but provides additional control
  on the direction of the nudging. In contrast to \code{\link[ggplot2]{position_nudge}},
  \code{\link{position_nudge_center}} and all other position functions defined in
  packaged 'ggpp' and 'ggrepel' keep the original coordinates thus allowing
  the plotting of connecting segments and arrows.
}
\examples{

# Same output as with geom_point()
ggplot(mpg[1:20, ],
       aes(cyl, hwy)) +
  geom_point_s()

ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               color = "red",
               segment.colour = "brown") +
  geom_point_s()

ggplot(mpg[1:20, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_nudge_keep(x = 0.2),
               color = "red",
               segment.colour = "brown") +
  geom_point_s()

ggplot(mpg[1:50, ],
       aes(cyl, hwy, label = drv)) +
  geom_point_s(position = position_jitternudge(width = 0.66, height = 2,
                                               seed = 456,
                                               nudge.from = "jittered",
                                               kept.origin = "original"),
               color = "red",
               arrow = grid::arrow(length = grid::unit(0.4, "lines"))) +
  geom_point_s()

}
\seealso{
\code{\link[ggplot2]{geom_point}}, \code{\link{geom_text_s}},
  \code{\link{position_nudge_keep}}, \code{\link{position_nudge_to}},
  \code{\link{position_jitternudge}}, \code{\link{position_dodgenudge}} and
  \code{\link{position_stacknudge}}.
}
