% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-jama.R
\name{pal_jama}
\alias{pal_jama}
\title{Journal of the American Medical Association Color Palettes}
\usage{
pal_jama(palette = c("default"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"default"}
(7-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}
}
\description{
Color palette inspired by plots in
\emph{The Journal of the American Medical Association}.
}
\examples{
library("scales")
show_col(pal_jama("default")(7))
show_col(pal_jama("default", alpha = 0.6)(7))
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{https://nanx.me}{https://nanx.me}>
}

