## Polygon data ----
#' Desikan-Killiany Cortical Atlas
#'
#' Coordinate data for the Desikan-Killiany Cortical atlas,
#' with 40 regions in on the cortical surface of the brain.
#'
#' @docType data
#' @name dk
#' @usage data(dk)
#' @keywords datasets
#' @family ggseg_atlases
#'
#' @references Fischl et al. (2004) Cerebral Cortex 14:11-22
#' (\doi{10.1093/cercor/bhg087})
#'
#' @return An object of class 'brain_atlas' for plotting with ggseg
#'
#' @examples
#' data(dk)
"dk"


#' Freesurfer automatic subcortical segmentation of a brain volume
#'
#' Coordinate data for the subcortical parcellations implemented
#' in Freesurfer.
#'
#' @docType data
#' @name aseg
#' @usage data(aseg)
#' @family ggseg_atlases
#'
#' @keywords datasets
#'
#' @references Fischl et al., (2002). Neuron, 33:341-355
#' (\href{https://www.pubmed.ncbi.nlm.nih.gov/11832223}{PubMed})
#'
#' @return An object of class 'brain_atlas' for plotting with ggseg
#'
#' @examples
#' data(aseg)
"aseg"
