% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqrplot.R
\name{ggseqrplot}
\alias{ggseqrplot}
\title{Representative Sequence plot}
\usage{
ggseqrplot(
  seqdata,
  diss,
  group = NULL,
  criterion = "density",
  coverage = 0.25,
  nrep = NULL,
  pradius = 0.1,
  dmax = NULL,
  border = FALSE,
  proportional = TRUE,
  weighted = TRUE,
  stats = TRUE,
  colored.stats = NULL,
  facet_ncol = NULL
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{diss}{pairwise dissimilarities between sequences in \code{seqdata} (see \code{TraMineR::seqdist})}

\item{group}{A vector of the same length as the sequence data indicating group membership. When not NULL, a distinct plot is generated for each level of group.}

\item{criterion}{the representativeness criterion for sorting the candidate list. One of \code{"freq"} (sequence
      frequency), \code{"density"} (neighborhood density), \code{"mscore"} (mean state frequency), \code{"dist"}
      (centrality) and \code{"prob"} (sequence likelihood). See details.}

\item{coverage}{coverage threshold, i.e., minimum proportion of sequences that should have a representative in their
      neighborhood (neighborhood radius is defined by \code{pradius}).}

\item{nrep}{number of representative sequences. If \code{NULL} (default), the size of the representative set is
     controlled by \code{coverage}.}

\item{pradius}{neighborhood
radius as a percentage of the maximum (theoretical)
distance \code{dmax}. Defaults to 0.1 (10\%). Sequence \eqn{y} is
redundant to sequence \eqn{x} when it is in the neighborhood of \eqn{x}, i.e., within a distance
\code{pradius*dmax} from \eqn{x}.}

\item{dmax}{maximum theoretical distance. The \code{dmax} value is used to derive the neighborhood radius as \code{pradius*dmax}. If \code{NULL}, the value of \code{dmax} is derived from the dissimilarity matrix.}

\item{border}{if \code{TRUE} bars are plotted with black outline; default is \code{FALSE} (also accepts \code{NULL})}

\item{proportional}{if \code{TRUE} (default), the sequence heights are
displayed proportional to the number of represented sequences}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{stats}{if \code{TRUE} (default), mean discrepancy in each subset
defined by all sequences attributed to one representative sequence and the
mean distance to this representative sequence are displayed.}

\item{colored.stats}{specifies if representatives in stats plot should be
color coded; only recommended if number of representatives is small;
if set to \code{NULL} (default) colors are used if n rep. <= 10;
use \code{TRUE} or \code{FALSE} to change manually}

\item{facet_ncol}{specifies the number of columns in the plot (relevant if !is.null(group))}
}
\value{
A representative sequence plot using \code{\link[ggplot2]{ggplot}}.
}
\description{
Function for rendering representative sequence plots with
\code{\link[ggplot2]{ggplot2}} \insertCite{wickham2016}{ggseqplot} instead of base
R's \code{\link[base]{plot}} function that is used by
\code{\link[TraMineR:seqplot]{TraMineR::seqplot}} \insertCite{gabadinho2011}{ggseqplot}.
}
\details{
The representative sequence plot displays a set of distinct sequences as sequence index plot.
The set of representative sequences is extracted from the sequence data by an internal call of
\code{\link[TraMineR:seqrep]{TraMineR::seqrep}} according to the criteria listed in the
arguments section above.

The extracted sequences are plotted by a call of \code{\link[ggseqplot:ggseqiplot]{ggseqiplot}} which uses
\code{\link[ggplot2:geom_rect]{ggplot2::geom_rect}} to render the sequences. If \code{stats = TRUE} the
index plots are complemented by information on the "quality" of the representative sequences.
For further details on representative sequence plots see \insertCite{gabadinho2011a;textual}{ggseqplot}
and the documentation of \code{\link[TraMineR:plot.stslist.rep]{TraMineR::plot.stslist.rep}},
\code{\link[TraMineR:seqplot]{TraMineR::seqplot}}, and \code{\link[TraMineR:seqrep]{TraMineR::seqrep}}.

Note that \code{ggseqrplot} uses \code{\link[patchwork]{patchwork}} to combine the different components
of the plot. If you want to adjust the appearance of the composed plot, for instance by changing the
plot theme, you should consult the documentation material of \code{\link[patchwork]{patchwork}}.
}
\examples{
# Use examples from TraMineR
library(TraMineR)
# Defining a sequence object with the data in columns 10 to 25
# (family status from age 15 to 30) in the biofam data set
data(biofam)
# Use sample of 300 cases
set.seed(123)
biofam <- biofam[sample(nrow(biofam),150),]
biofam.lab <- c("Parent", "Left", "Married", "Left+Marr",
"Child", "Left+Child", "Left+Marr+Child", "Divorced")
biofam.seq <- seqdef(biofam, 10:25, labels=biofam.lab)

# Computing the distance matrix
biofam.dhd <- seqdist(biofam.seq, method="DHD")

# Representative sequence  plot (using defaults)
# ... with TraMineR::seqplot
seqrplot(biofam.seq, diss = biofam.dhd)

# ... with ggseqrplot
ggseqrplot(biofam.seq, diss = biofam.dhd)
}
\references{
\insertAllCited{}
}
\author{
Marcel Raab
}
