% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{animate_histogram}
\alias{animate_histogram}
\title{An animated histogram of a single variable across targets.}
\usage{
animate_histogram(
  output,
  parameter,
  dimension = 1,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  bins = 30,
  xlimits = NULL,
  ylimits = NULL,
  default_title = FALSE,
  duration = NULL,
  animate_plot = TRUE,
  save_filename = NULL,
  save_path = NULL
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{parameter}{The parameter we wish to histogram.}

\item{dimension}{(optional) The dimension of the parameter we wish to histogram. (default is 1)}

\item{target}{(optionaL) If specified, will fix to this target, and animate over ExternalTarget (if present in output).}

\item{external_target}{(optionaL) If specified, will fix to this external_target, and animate over Target.}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the histogram. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{bins}{(optional) Number of bins for the histogram. (default 30)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}

\item{duration}{(optional) The duration of the animation. (defaults to producing an animation that uses 10 frames per second)}

\item{animate_plot}{(optiional) If TRUE, will return an animation. If FALSE, returns a gganim object that can be furher modified before animating. (defaults to FALSE)}

\item{save_filename}{(optional) If specified, the animation will be saved to a gif with this filename. (default is not to save)}

\item{save_path}{(optional) If specified along with save_filename, will save the gif to save_path/save_filename. (defaults to working directory)}
}
\value{
An animated histogram
}
\description{
An animated histogram of a single variable across targets.
}
