% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-color.R
\name{stat_color}
\alias{stat_color}
\title{Calculate colours from wavelength.}
\usage{
stat_color(mapping = NULL, data = NULL, geom = "point", type = "CMF",
  position = "identity", na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{type}{character one of "CMF" (color matching function) or "CC"
(color coordinates).}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_color} computes color definitions according to human vision.
}
\section{Computed variables}{

\describe{
  \item{color}{color corresponding to x-value giving wavelength in
  nanometres.}
}
}
\examples{
library(photobiology)
library(ggplot2)
ggplot(sun.spct, aes(w.length, s.e.irrad)) + geom_line() +
  stat_color() + scale_color_identity()

}
\seealso{
\code{\link[photobiology]{color}}, which is used internally.

Other stats functions: \code{\link{stat_peaks}},
  \code{\link{stat_wb_contribution}},
  \code{\link{stat_wb_irrad}}, \code{\link{stat_wb_label}},
  \code{\link{stat_wb_mean}},
  \code{\link{stat_wb_relative}},
  \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_total}}, \code{\link{stat_wl_strip}},
  \code{\link{stat_wl_summary}}
}

