% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-filter-spct.R
\name{A_plot}
\alias{A_plot}
\title{Plot a filter spectrum.}
\usage{
A_plot(spct, w.band, range, label.qty, span, annotations, text.size, na.rm, ...)
}
\arguments{
\item{spct}{a filter_spct object}

\item{w.band}{list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}

\item{...}{other arguments passed to absorbance()}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a source_spct
object showing spectral absorbance.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\keyword{internal}
