% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-plot-utils.R
\name{find_idfactor}
\alias{find_idfactor}
\title{Find 'idfactor'}
\usage{
find_idfactor(
  spct,
  idfactor,
  annotations,
  facets,
  map.linetype,
  num.columns = 1L,
  ...
)
}
\arguments{
\item{spct}{generic_spct or derived object}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the default
"spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped to the
spectra and the user needs to use 'ggplot2' functions to manually map an
aesthetic or use facets for the spectra.}

\item{annotations}{a character vector.}

\item{facets}{logical or numeric Flag indicating if facets are to be created
when the data contains multiple spectra, if numeric the number of columns.}

\item{map.linetype}{logical flag indicating that the id is to be mapped to
the linetype aesthetic.}

\item{num.columns}{numeric Number of data columns from multiple scans. Relevant
only to \code{raw_spct} and \code{cps_spct} objects.}

\item{...}{currently not used.}
}
\value{
A list object containing a list of ggplot components and a vector of
  annotations names as members.
}
\description{
Find if an 'idfactor' is present and build a suitable plot chuck.
}
\details{
Implement facets and/or a mapping to linetype. The mapping to
  linetype is done only if the number of spectra is <= 13 because of the
  number of values available in the scale.
}
\keyword{internal}
