% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-cps-spct.R
\name{scale_y_cps_continuous}
\alias{scale_y_cps_continuous}
\title{Counts-per-second  y-scale}
\usage{
scale_y_cps_continuous(unit.exponent = 0,
  name = cps_label(unit.exponent = unit.exponent),
  labels = SI_pl_format(exponent = unit.exponent), ...)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(white_led.cps_spct) +
  geom_line() +
  scale_y_cps_continuous() +
  scale_x_wl_continuous()

ggplot(white_led.cps_spct) +
  geom_line() +
  scale_y_cps_continuous(3) +
  scale_x_wl_continuous()

}
