% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdotplotstats.R
\name{grouped_ggdotplotstats}
\alias{grouped_ggdotplotstats}
\title{Grouped histograms for distribution of a labeled numeric variable}
\usage{
grouped_ggdotplotstats(
  data,
  ...,
  grouping.var,
  plotgrid.args = list(),
  annotation.args = list()
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{...}{
  Arguments passed on to \code{\link[=ggdotplotstats]{ggdotplotstats}}
  \describe{
    \item{\code{y}}{Label or grouping variable.}
    \item{\code{centrality.line.args}}{A list of additional aesthetic arguments to be
passed to the \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} used to display the lines
corresponding to the centrality parameter.}
    \item{\code{x}}{A numeric variable from the data frame \code{data}.}
    \item{\code{type}}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}
    \item{\code{test.value}}{A number indicating the true value of the mean (Default:
\code{0}).}
    \item{\code{digits}}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}
    \item{\code{conf.level}}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}
    \item{\code{tr}}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of \code{1/2}, \code{sqrt(2)/2}, and \code{1}, respectively. In case of an ANOVA, this
value corresponds to scale for fixed effects.}
    \item{\code{effsize.type}}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}
    \item{\code{xlab}}{Label for \code{x} axis variable. If \code{NULL} (default),
variable name for \code{x} will be used.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}
    \item{\code{centrality.plotting}}{Logical that decides whether centrality tendency
measure is to be displayed as a point with a label (Default: \code{TRUE}).
Function decides which central tendency measure to show depending on the
\code{type} argument.
\itemize{
\item \strong{mean} for parametric statistics
\item \strong{median} for non-parametric statistics
\item \strong{trimmed mean} for robust statistics
\item \strong{MAP estimator} for Bayesian statistics
}

If you want default centrality parameter, you can specify this using
\code{centrality.type} argument.}
    \item{\code{centrality.type}}{Decides which centrality parameter is to be displayed.
The default is to choose the same as \code{type} argument. You can specify this
to be:
\itemize{
\item \code{"parameteric"} (for \strong{mean})
\item \code{"nonparametric"} (for \strong{median})
\item \code{robust} (for \strong{trimmed mean})
\item \code{bayes} (for \strong{MAP estimator})
}

Just as \code{type} argument, abbreviations are also accepted.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}
    \item{\code{ggtheme}}{A \code{{ggplot2}} theme. Default value is
\code{\link[=theme_ggstatsplot]{theme_ggstatsplot()}}. Any of the \code{{ggplot2}} themes (e.g.,
\code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}}), or themes from extension packages are allowed
(e.g., \code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()},
etc.). But note that sometimes these themes will remove some of the details
that \code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{\link[=ggbetweenstats]{ggbetweenstats()}} shows details about multiple comparison test as a
label on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}
    \item{\code{ylab}}{Labels for \code{y} axis variable. If \code{NULL} (default),
variable name for \code{y} will be used.}
    \item{\code{point.args}}{A list of additional aesthetic arguments to be passed to
the \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}
  }}

\item{grouping.var}{A single grouping variable.}

\item{plotgrid.args}{A \code{list} of additional arguments passed to
\code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}, except for \code{guides} argument which is already
separately specified here.}

\item{annotation.args}{A \code{list} of additional arguments passed to
\code{\link[patchwork:plot_annotation]{patchwork::plot_annotation()}}.}
}
\description{
Helper function for \code{ggstatsplot::ggdotplotstats} to apply this function
across multiple levels of a given factor and combining the resulting plots
using \code{ggstatsplot::combine_plots}.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggdotplotstats.html}
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) withAutoprint(\{ # examplesIf}
# for reproducibility
set.seed(123)
library(dplyr, warn.conflicts = FALSE)

# removing factor level with very few no. of observations
df <- filter(ggplot2::mpg, cyl \%in\% c("4", "6", "8"))

# plot
grouped_ggdotplotstats(
  data         = df,
  x            = cty,
  y            = manufacturer,
  grouping.var = cyl,
  test.value   = 15.5
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{grouped_gghistostats}}, \code{\link{ggdotplotstats}},
\code{\link{gghistostats}}
}
