% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggbarstats.R
\name{grouped_ggbarstats}
\alias{grouped_ggbarstats}
\title{Grouped bar (column) charts with statistical tests}
\usage{
grouped_ggbarstats(
  data,
  x,
  y,
  counts = NULL,
  grouping.var,
  output = "plot",
  plotgrid.args = list(),
  annotation.args = list(),
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted.}

\item{x}{The variable to use as the \strong{rows} in the contingency table. Please
note that if there are empty factor levels in your variable, they will be
dropped.}

\item{y}{The variable to use as the \strong{columns} in the contingency table.
Please note that if there are empty factor levels in your variable, they
will be dropped. Default is \code{NULL}. If \code{NULL}, one-sample proportion test
(a goodness of fit test) will be run for the \code{x} variable. Otherwise an
appropriate association test will be run. This argument can not be \code{NULL}
for \code{ggbarstats} function.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{plotgrid.args}{A \code{list} of additional arguments passed to
\code{patchwork::wrap_plots}, except for \code{guides} argument which is already
separately specified here.}

\item{annotation.args}{A \code{list} of additional arguments passed to
\code{patchwork::plot_annotation}.}

\item{...}{
  Arguments passed on to \code{\link[=ggbarstats]{ggbarstats}}
  \describe{
    \item{\code{xlab}}{Custom text for the \code{x} axis label (Default: \code{NULL}, which
will cause the \code{x} axis label to be the \code{x} variable).}
    \item{\code{ylab}}{Custom text for the \code{y} axis label (Default: \code{NULL}).}
    \item{\code{type}}{A character specifying the type of statistical approach.
Four possible options:

\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

Corresponding abbreviations are also accepted: \code{"p"} (for parametric),
\code{"np"} (for nonparametric), \code{"r"} (for robust), or \code{"bf"} (for Bayesian).}
    \item{\code{paired}}{Logical indicating whether data came from a within-subjects or
repeated measures design study (Default: \code{FALSE}). If \code{TRUE}, McNemar's
test expression will be returned. If \code{FALSE}, Pearson's chi-square test will
be returned.}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{label}}{Character decides what information needs to be displayed
on the label in each pie slice. Possible options are \code{"percentage"}
(default), \code{"counts"}, \code{"both"}.}
    \item{\code{label.args}}{Additional aesthetic arguments that will be passed to
\code{geom_label}.}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{proportion.test}}{Decides whether proportion test for \code{x} variable is to
be carried out for each level of \code{y} (Default: \code{TRUE}). In \code{ggbarstats},
only \emph{p}-values from this test will be displayed.}
    \item{\code{perc.k}}{Numeric that decides number of decimal places for percentage
labels (Default: \code{0}).}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{ratio}}{A vector of proportions: the expected proportions for the
proportion test (should sum to 1). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
This means if there are two levels this will be \code{ratio = c(0.5,0.5)} or if
there are four levels this will be \code{ratio = c(0.25,0.25,0.25,0.25)}, etc.}
    \item{\code{conf.level}}{Scalar between \code{0} and \code{1}. If unspecified, the defaults
return \verb{95\%} confidence/credible intervals (\code{0.95}).}
    \item{\code{sampling.plan}}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}
    \item{\code{fixed.margin}}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}
    \item{\code{prior.concentration}}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{legend.title}}{Title text for the legend.}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{package}}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}
    \item{\code{palette}}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{ggplot2} function or a list of \code{ggplot2} functions.}
  }}
}
\description{
Helper function for \code{ggstatsplot::ggbarstats} to apply this function across
multiple levels of a given factor and combining the resulting plots using
\code{ggstatsplot::combine_plots}.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(ggstatsplot)

# let's create a smaller dataframe
diamonds_short <- ggplot2::diamonds \%>\%
  dplyr::filter(.data = ., cut \%in\% c("Very Good", "Ideal")) \%>\%
  dplyr::filter(.data = ., clarity \%in\% c("SI1", "SI2", "VS1", "VS2")) \%>\%
  dplyr::sample_frac(tbl = ., size = 0.05)

# plot
# let's skip statistical analysis
grouped_ggbarstats(
  data = diamonds_short,
  x = color,
  y = clarity,
  grouping.var = cut,
  plotgrid.args = list(nrow = 2)
)
}
}
\seealso{
\code{\link{ggbarstats}}, \code{\link{ggpiestats}},
\code{\link{grouped_ggpiestats}}
}
