% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statStudent.R
\name{geom_student}
\alias{geom_student}
\title{Student CI plot}
\usage{
geom_student(mapping = NULL, data = NULL, position = "identity",
  width = 0.25, type = "density", scale = TRUE, draw_lines = NULL,
  draw_mean = TRUE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{width}{Scaling parameter for the width of the violin/rectangle.}

\item{type}{Type of the plot. The default is \code{density} which draws violin style density plot,
whereas \code{"box"} draws a rectangle shaped gradient plot.}

\item{scale}{If \code{"TRUE"} (default), violins/rectangles are scaled according
to the maximum width of the groups (\code{max(dt(0, df) / se)}).}

\item{draw_lines}{If not \code{NULL} (default), draw horizontal lines
at the given quantiles of the density estimate.}

\item{draw_mean}{If \code{TRUE} (default), draw horizontal line at mean.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed to \code{layer()}, such as fixed aesthetics.}
}
\value{
A ggplot object.
}
\description{
A Student CI plot (or Violin CI plot) is a mirrored density plot similar to violin plot
but instead of kernel density estimate it is based on the density of the t-distribution.
It can be though of as a continuous "confidence interval density" (hence the name),
which could reduce the dichotomous interpretations due to a fixed confidence level.
\code{geom_student} can also be used to draw Gradient CI plots (using argument \code{type}),
which replaces the violin shaped density with a rectangle.
}
\examples{
library("dplyr")
library("ggplot2")
library("scales")

ci_levels <- c(0.999, 0.95, 0.9, 0.8, 0.5)
n <- length(ci_levels)
ci_levels <- factor(ci_levels, levels = ci_levels)
PlantGrowth \%>\% dplyr::group_by(group) \%>\%
  dplyr::summarise(
    mean = mean(weight),
    df = dplyr::n() - 1,
    se = sd(weight)/sqrt(df + 1)) \%>\%
 dplyr::full_join(
   data.frame(group =
     rep(levels(PlantGrowth$group), each = n),
     level = ci_levels), by = "group") -> d

p <- ggplot(data = d, aes(group)) +
 geom_student(aes(mean = mean, se = se, df = df,
   level = level, fill = level), draw_lines = c(0.95, 0.5))
p
g <- scales::seq_gradient_pal("#e5f5f9", "#2ca25f")
p + scale_fill_manual(values=g(seq(0,1,length = n))) + theme_bw()

p2 <- ggplot(data = d, aes(group)) +
 geom_student(aes(mean = mean, se = se, df = df,
   level = level, fill = level), type = "box", draw_lines = c(0.95, 0.5))
p2

}
\references{
Helske, J, S Helske, M Cooper, A Ynnerman, and L Besançon (2020).
Are You Sure You’re Sure? - Effects of Visual Representation on the Cliff Effect in Statistical Inference.
Under review. https://arxiv.org/abs/2002.07671
}
