% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_dates_seasonal.R
\name{align_dates_seasonal}
\alias{align_dates_seasonal}
\alias{align_and_bin_dates_seasonal}
\title{Align dates for seasonal comparison}
\usage{
align_dates_seasonal(
  x,
  dates_from = NULL,
  date_resolution = c("week", "isoweek", "epiweek", "day", "month"),
  start = NULL,
  target_year = NULL,
  drop_leap_week = TRUE
)

align_and_bin_dates_seasonal(
  x,
  dates_from,
  n = 1,
  population = 1,
  fill_gaps = FALSE,
  date_resolution = c("week", "isoweek", "epiweek", "day", "month"),
  start = NULL,
  target_year = NULL,
  drop_leap_week = TRUE,
  .groups = "drop"
)
}
\arguments{
\item{x}{Either a data frame with a date column, or a date vector.\cr
Supported date formats are \code{date} and \code{datetime} and also commonly used character strings:
\itemize{
\item ISO dates \code{"2024-03-09"}
\item Month \code{"2024-03"}
\item Week \code{"2024-W09"} or \code{"2024-W09-1"}
}}

\item{dates_from}{Column name containing the dates to align and bin. Used when x is a data.frame.}

\item{date_resolution}{Character string specifying the temporal resolution.
One of:
\itemize{
\item \code{"week"} or \code{"isoweek"} - Calendar weeks (ISO 8601), epidemiological reporting weeks as used by the ECDC.
\item \code{"epiweek"} - Epidemiological weeks as defined by the US CDC (weeks start on Sunday).
\item \code{"month"} - Calendar months
\item \code{"day"} - Daily resolution
}}

\item{start}{Numeric value indicating epidemic season start, i.e. the start and end of the new year interval:
\itemize{
\item For \code{week/epiweek}: week number (default: 28, approximately July)
\item For \code{month}: month number (default: 7 for July)
\item For \code{day}: day of year (default: 150, approximately June)
If start is set to "1" the alignment is done for yearly comparison and the shift in dates for seasonality is skipped.
}}

\item{target_year}{Numeric value for the reference year to align dates to. The default target year
is the start of the most recent season in the data. This way the most recent dates stay unchanged.}

\item{drop_leap_week}{If \code{TRUE} and date_resolution is \code{week}, \code{isoweek} or \code{epiweek}, leap weeks (week 53)
are dropped if they are not in the most recent season. Set to \code{FALSE} to retain leap weeks from all seasons.
Dropping week 53 from historical data is the most common approach. Otherwise historical data for week 53 would
map to week 52 if the target season has no leap week, resulting in a doubling of the case counts.}

\item{n}{Numeric column with case counts (or weights). Supports quoted and unquoted column names.}

\item{population}{A number or a numeric column with the population size. Used to calculate the incidence.}

\item{fill_gaps}{Logical; If \code{TRUE}, gaps in the time series will be filled with 0 cases.
Useful for ensuring complete time series without missing periods. Defaults to \code{FALSE}.}

\item{.groups}{See \code{\link[dplyr:summarise]{dplyr::summarise()}}.}
}
\value{
A data frame with standardized date columns:
\itemize{
\item \code{year}: Calendar year from original date
\item \code{week/month/day}: Time unit based on chosen resolution
\item \code{date_aligned}: Date standardized to target year
\item \code{season}: Epidemic season identifier (e.g., "2023/24"), if \code{start = 1} this is the year only (e.g. 2023).
\item \code{current_season}: Logical flag for most recent season
}

Binning also creates the columns:
\itemize{
\item \code{n}: Sum of cases in bin
\item \code{incidence}: Incidence calculated using n/population
}
}
\description{
\code{align_dates_seasonal()} standardizes dates from multiple years to enable comparison of epidemic curves
and visualization of seasonal patterns in infectious disease surveillance data.
Commonly used for creating periodicity plots of respiratory diseases like
influenza, RSV, or COVID-19.\cr\cr
\code{align_and_bin_dates_seasonal()} is a convenience wrapper that first aligns the dates and then bins the data to calculate counts and incidence.
}
\details{
This function helps create standardized epidemic curves by aligning surveillance
data from different years. This enables:
\itemize{
\item Comparison of disease patterns across multiple seasons
\item Identification of typical seasonal trends
\item Detection of unusual disease activity
\item Assessment of current season against historical patterns
}

The alignment can be done at different temporal resolutions (daily, weekly,
monthly) with customizable season start points to match different disease
patterns or surveillance protocols.
}
\examples{
# Seasonal Visualization of Germany Influenza Surveillance Data
library(ggplot2)

influenza_germany |>
  align_dates_seasonal(
    dates_from = ReportingWeek, date_resolution = "epiweek", start = 28
  ) -> df_flu_aligned

ggplot(df_flu_aligned, aes(x = date_aligned, y = Incidence, color = season)) +
  geom_line() +
  facet_wrap(~AgeGroup) +
  theme_bw() +
  theme_mod_rotate_x_axis_labels_45()

}
