% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-tern.R
\docType{data}
\name{coord_tern}
\alias{coord_tern}
\alias{coord_tern}
\alias{CoordTern}
\title{Ternary Coordinate System}
\usage{
coord_tern(Tlim = NULL, Llim = NULL, Rlim = NULL, expand = TRUE)
}
\arguments{
\item{Tlim}{the range of T in the ternary space}

\item{Llim}{the range of L in the ternary space}

\item{Rlim}{the range of R in the ternary space}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}
}
\value{
\code{coord_tern} returns a CoordTern ggproto
}
\description{
\code{coord_tern} is a function which creates a transformation mechanism between the ternary system, and, the cartesian system.
It inherits from the fixed coordinate system, employing fixed ratio between x and y axes once transformed.
}
\section{Aesthetics (Required in Each Layer)}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("coord", "tern")}

Abovementioned limitations include the types of geometries which can be used (ie approved geometries), 
or modifications to required aesthetic mappings. One such essential patch is, for approved geometries previously 
requiring \code{x} and \code{y} coordinates, now require an additional \code{z} coordinate, and, 
\code{\link{geom_segment}} goes one step further in that it requires both an additional 
\code{z} and \code{zend} coordinate mappings. 

In essence, the required aesthetics are the product between what
is required of each 'layer' and what is required of the 'coordinate system'.
}

\author{
Nicholas Hamilton
}
\keyword{datasets}
