\name{scale_colour_gradient2_tableau}
\alias{scale_color_gradient2_tableau}
\alias{scale_colour_gradient2_tableau}
\alias{scale_fill_gradient2_tableau}
\title{Tableau diverging colour scales (continuous)}
\usage{
scale_colour_gradient2_tableau(palette = "Red-Blue", ..., space = "rgb",
  na.value = "grey50", guide = "colourbar")

scale_fill_gradient2_tableau(palette = "Red-Blue", ..., space = "rgb",
  na.value = "grey50", guide = "colourbar")

scale_color_gradient2_tableau(palette = "Red-Blue", ..., space = "rgb",
  na.value = "grey50", guide = "colourbar")
}
\arguments{
  \item{guide}{Type of legend. Use \code{"colourbar"} for
  continuous colour bar, or \code{"legend"} for discrete
  colour legend.}

  \item{palette}{Palette name: One of
  \Sexpr[results=rd,stage=build]{ggthemes:::charopts(names(ggthemes::ggthemes_data$tableau$divergent))}.}

  \item{space}{Colour space in which to calculate
  gradient.}

  \item{...}{Other arguments passed on to
  \code{\link{discrete_scale}} to control name, limits,
  breaks, labels and so forth.}

  \item{na.value}{Colour to use for missing values}
}
\description{
Tableau diverging colour scales (continuous)
}
\examples{
dsub <- subset(diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub$diff <- with(dsub, sqrt(abs(x-y))* sign(x-y))
d <- qplot(x, y, data=dsub, colour=diff)
d + scale_colour_gradient2_tableau()
d + scale_colour_gradient2_tableau("Orange-Blue")
d + scale_colour_gradient2_tableau("Temperature")
}
\seealso{
Other colour tableau:
\code{\link{scale_color_continuous_tableau}},
\code{\link{scale_color_gradient_tableau}},
\code{\link{scale_colour_gradient_tableau}},
\code{\link{scale_fill_gradient_tableau}};
\code{\link{scale_color_tableau}},
\code{\link{scale_colour_tableau}},
\code{\link{scale_fill_tableau}};
\code{\link{tableau_color_pal}};
\code{\link{tableau_div_gradient_pal}};
\code{\link{tableau_seq_gradient_pal}}
}

