% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-rangeframe.R
\docType{data}
\name{geom_rangeframe}
\alias{GeomRangeFrame}
\alias{geom_rangeframe}
\title{Range Frames}
\usage{
geom_rangeframe(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", sides = "bl", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{sides}{A string that controls which sides of the plot the frames appear on.
It can be set to a string containing any of \code{'trbl'}, for top, right,
bottom, and left.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}
}
\description{
Axis lines which extend to the maximum and minimum of the plotted data.
}
\section{Aesthetics}{

\itemize{
\item colour
\item size
\item linetype
\item alpha
}
}
\examples{
library("ggplot2")
ggplot(mtcars, aes(wt, mpg)) +
 geom_point() +
 geom_rangeframe() +
 theme_tufte()
}
\references{
Tufte, Edward R. (2001) The Visual Display of
Quantitative Information, Chapter 6.
}
\seealso{
Other geom tufte: \code{\link{geom_tufteboxplot}}
}
\keyword{datasets}

