% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptol.R
\name{ptol_pal}
\alias{ptol_pal}
\title{Color Palettes from Paul Tol's "Colour Schemes"}
\usage{
ptol_pal()
}
\description{
Qualitative color palettes from Paul Tol,
\href{https://personal.sron.nl/~pault/colourschemes.pdf}{"Colour Schemes"}.
}
\details{
Incorporation of the palette into an R package was originally inspired by
Peter Carl's [Paul Tol 21 Gun Salute](https://tradeblotter.wordpress.com/2013/02/28/the-paul-tol-21-color-salute/)
}
\examples{
library("scales")
show_col(ptol_pal()(6))
show_col(ptol_pal()(4))
show_col(ptol_pal()(12))
}
\references{
Paul Tol. 2012. "Colour Schemes." SRON Technical Note, SRON/EPS/TN/09-002.
 \url{https://personal.sron.nl/~pault/colourschemes.pdf}
}
\seealso{
Other colour ptol: \code{\link{scale_colour_ptol}}
}
