% Generated by roxygen2 (4.0.2): do not edit by hand
\name{layer_boxplots}
\alias{layer_boxplots}
\title{Display data with a boxplot.}
\usage{
layer_boxplots(vis, ..., coef = 1.5, width = NULL)
}
\arguments{
\item{vis}{Visualisation to modify}

\item{...}{Visual properties used to override defaults.}

\item{coef}{The maximum length of the whiskers as multiple of the
inter-quartile range. Default value is 1.5.}

\item{width}{Width of each bar. When x is continuous, this controls the width
in the same units as x. When x is categorical, this controls the width as a
proportion of the spacing between items (default is 0.9).}
}
\description{
This will add boxplots to a plot. The action of \code{layer_boxplots} depends
on whether the \code{x} prop is continuous or categorical.
}
\details{
The upper and lower "hinges" correspond to the first and third quartiles (the
25th and 75th percentiles). This differs slightly from the method used by the
\code{boxplot} function, and may be apparent with small samples. See
\code{\link{boxplot.stats}} for more information on how hinge positions are
calculated for \code{boxplot}.

The upper whisker extends from the hinge to the highest value that is within
1.5 * IQR of the hinge, where IQR is the inter-quartile range, or distance
between the first and third quartiles. The lower whisker extends from the
hinge to the lowest value within 1.5 * IQR of the hinge. Data beyond the end
of the whiskers are outliers and plotted as points (as specified by Tukey).
}
\examples{
library(dplyr)

mtcars \%>\% ggvis(~factor(cyl), ~mpg) \%>\% layer_boxplots()
# Set the width of the boxes to half the space between tick marks
mtcars \%>\% ggvis(~factor(cyl), ~mpg) \%>\% layer_boxplots(width = 0.5)

# Continuous x: boxes fill width between data values
mtcars \%>\% ggvis(~cyl, ~mpg) \%>\% layer_boxplots()
# Setting width=0.5 makes it 0.5 wide in the data space, which is 1/4 of the
# distance between data values in this particular case.
mtcars \%>\% ggvis(~cyl, ~mpg) \%>\% layer_boxplots(width = 0.5)

# Smaller outlier points
mtcars \%>\% ggvis(~factor(cyl), ~mpg) \%>\% layer_boxplots(size := 20)
}
\seealso{
\code{\link{compute_boxplot}} for more information on how data is
  transformed.
}

