% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_collab.R
\name{gh_collab_check}
\alias{gh_collab_check}
\title{Check if a user is a collaborator}
\usage{
gh_collab_check(path, collaborator, ..., messages = TRUE)
}
\arguments{
\item{path}{GitHub repo path of the form "{username}/{repo}". If not provided, will default to current repo.}

\item{collaborator}{The collaborator for whom to call this function.}

\item{...}{Additional parameters, see \url{https://docs.github.com/en/rest}}

\item{messages}{Logical: Should a message indicating the status of the function be printed? TRUE by default.}
}
\value{
TRUE if the individual is a collaborator on the repo; FALSE otherwise.
}
\description{
Check if a user is a collaborator
}
\seealso{
\code{\link[=gh_collab_list]{gh_collab_list()}} for listing all current repository collaborators.

Other Collaborations: 
\code{\link{gh_collab_invite}()},
\code{\link{gh_collab_list}()},
\code{\link{gh_collab_pending}()},
\code{\link{gh_collab_remove}()},
\code{\link{gh_collab_uninvite}()}
}
\concept{Collaborations}
