% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_repos.R
\name{gh_repos_mutate}
\alias{gh_repos_mutate}
\title{Change repository features}
\usage{
gh_repos_mutate(path, ...)
}
\arguments{
\item{path}{GitHub repo path of the form "{username}/{repo}". If not provided, will default to current repo.}

\item{...}{Additional parameters, see \url{https://docs.github.com/en/rest}}
}
\value{
NA; called for side effects to manipulate GitHub repositories.
}
\description{
This function allows you to update a repository's features. You can easily
change the repository's name, privacy settings, and more.
}
\examples{

\dontrun{

# Create a Private Repo
gh_repos_create(path = "jdtrat/ghee_test", private = TRUE, description = "A test repository.")

# Disable Issues
gh_repos_mutate(path = "jdtrat/ghee_test", has_issues = FALSE)

# Update Description
gh_repos_mutate(path = "jdtrat/ghee_test", description = "A test repository for {ghee}.")

# Remove Description
gh_repos_mutate("jdtrat/friend", description = NA)

# Change Privacy Settings
gh_repos_mutate(path = "jdtrat/ghee_test", private = FALSE)

# Change Repo Name
gh_repos_mutate(path = "jdtrat/ghee_test", name = "ghee_testing")

# Change Repo Name Back
# Note the path argument reflects the name change
gh_repos_mutate(path = "jdtrat/ghee_testing", name = "ghee_test")

# Delete Repo
# Note this requires a special GitHub Token and should be used with caution.
gh_repos_delete("jdtrat/ghee_test")

}


}
\seealso{
Other Repositories: 
\code{\link{gh_repos_create}()},
\code{\link{gh_repos_delete_internal}()},
\code{\link{gh_repos_delete}()},
\code{\link{gh_repos_list}()}
}
\concept{Repositories}
