% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_urban_audit.R
\name{gisco_get_urban_audit}
\alias{gisco_get_urban_audit}
\title{Download Geospatial Urban Audit Data from GISCO}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/urau/}{GISCO Urban Audit}
}
\usage{
gisco_get_urban_audit(
  year = "2020",
  epsg = "4326",
  update_cache = FALSE,
  cache_dir = NULL,
  spatialtype = "RG",
  level = NULL,
  country = NULL
)
}
\arguments{
\item{year}{Release year. One of
"2014", "2018" or "2020"}

\item{epsg}{projection of the map: 4-digit \href{https://spatialreference.org/ref/epsg/}{EPSG code}. One of:
\itemize{
\item "4326" - WGS84
\item "3035" - ETRS89 / ETRS-LAEA
\item "3857" - Pseudo-Mercator
}}

\item{update_cache}{a logical whether to update cache.}

\item{cache_dir}{a path to a cache directory. The directory have to exist.  The \code{NULL} (default) uses and creates \code{/gisco} directory in the temporary directory from \code{\link{tempdir}}. The directory can also be set with \code{options(gisco_cache_dir = <path>)}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
 \item RG: Regions - Multipolygon
 \item LB: Labels - Point
}}

\item{level}{Level of Urban Audit. Possible values are 'CITIES', 'FUA', 'GREATER_CITIES' or \code{NULL}. See Details.}

\item{country}{Optional. A character vector of country codes. See details.}
}
\value{
a \code{sf} object.
}
\description{
Downloads a simple feature (\code{sf}) object.
}
\details{
\code{level = NULL} would download the whole dataset including all levels

\code{country} could be either a vector of country names, a vector of ISO3 country codes or
a vector of Eurostat country codes.
}
\note{
Please check the download and usage provisions on \link{gisco_attributions}.
}
\examples{
library(sf)

GreatCities <-
  gisco_get_urban_audit(level = "GREATER_CITIES")

unique(GreatCities$CNTR_CODE)

countries <- gisco_get_countries()

plot(
  st_geometry(countries)  ,
  col = "grey10",
  xlim = c(-15, 25),
  ylim = c(35, 60)
)
plot(st_geometry(GreatCities),
     add = TRUE,
     col = "darkgoldenrod3")
box()
title(
  main = "Greater Cities on Europe (2020)",
  sub = gisco_attributions(copyright = FALSE),
  cex.main = 0.8,
  cex.sub = 0.7,
  line = 1
)
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
