% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-unit-country.R,
%   R/gisco-get-unit-nuts.R, R/gisco-get-unit-urban-audit.R
\encoding{UTF-8}
\name{gisco_get_unit}
\alias{gisco_get_unit}
\alias{gisco_get_unit_country}
\alias{gisco_get_unit_nuts}
\alias{gisco_get_unit_urban_audit}
\title{GISCO API single download}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}

All the source files are \code{.geojson} files.
}
\usage{
gisco_get_unit_country(
  unit = "ES",
  year = 2024,
  epsg = c(4326, 3857, 3035),
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = c(1, 3, 10, 20, 60),
  spatialtype = c("RG", "LB")
)

gisco_get_unit_nuts(
  unit = "ES416",
  year = 2024,
  epsg = c(4326, 3857, 3035),
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = c(1, 3, 10, 20, 60),
  spatialtype = c("RG", "LB")
)

gisco_get_unit_urban_audit(
  unit = "ES001F",
  year = 2021,
  epsg = c(4326, 3857, 3035),
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = c("RG", "LB")
)
}
\arguments{
\item{unit}{character vector of unit ids to be downloaded. See \strong{Details}.}

\item{year}{character string or number. Release year of the file.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{resolution}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item \code{"60"}: 1:60 million.
\item \code{"20"}: 1:20 million.
\item \code{"10"}: 1:10 million.
\item \code{"03"}: 1:3 million.
\item \code{"01"}: 1:1 million.
}}

\item{spatialtype}{character string. Type of geometry to be returned.
Options available are:
\itemize{
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
\item \code{"LB"}: Labels - \code{POINT} object.
}}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Download datasets of single spatial units from GISCO to the
\code{\link[=gisco_set_cache_dir]{cache_dir}}.

Unlike \code{\link[=gisco_get_countries]{gisco_get_countries()}}, \code{\link[=gisco_get_nuts]{gisco_get_nuts()}} or
\code{\link[=gisco_get_urban_audit]{gisco_get_urban_audit()}} (that downloads a full dataset and applies
filters), these functions download a single per unit, reducing the time
of downloading and reading into your \strong{R} session.
}
\details{
Check the available \code{unit} ids with the required
combination of arguments with \code{\link[=gisco_get_metadata]{gisco_get_metadata()}}.
}
\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
# Get metadata
cities <- gisco_get_metadata("urban_audit", 2020)


# Valencia, Spain
valencia <- cities[grep("Valencia", cities$URAU_NAME), ]
valencia
library(dplyr)
# Now get the sf objects and order by AREA_SQM
valencia_sf <- gisco_get_unit_urban_audit(
  unit = valencia$URAU_CODE,
  year = "2020",
) |>
  arrange(desc(AREA_SQM))
# Plot
library(ggplot2)

ggplot(valencia_sf) +
  geom_sf(aes(fill = URAU_CATG)) +
  scale_fill_viridis_d() +
  labs(
    title = "Valencia",
    subtitle = "Urban Audit 2020",
    fill = "Category"
  )
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gisco_get_metadata]{gisco_get_metadata()}}, \code{\link[=gisco_get_countries]{gisco_get_countries()}},
\code{\link[=gisco_get_nuts]{gisco_get_nuts()}}, \code{\link[=gisco_get_urban_audit]{gisco_get_urban_audit()}}.

See \code{\link[=gisco_id_api]{gisco_id_api}} to download via GISCO ID service
API.

Additional utils for downloading datasets:
\code{\link{gisco_bulk_download}()}
}
\concept{extra}
