% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-urban-audit.R
\name{gisco_get_urban_audit}
\alias{gisco_get_urban_audit}
\title{Urban Audit dataset}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/administrative-units}.
}
\usage{
gisco_get_urban_audit(
  year = 2021,
  epsg = 4326,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = c("RG", "LB"),
  country = NULL,
  level = c("all", "CITIES", "FUA", "GREATER_CITIES", "CITY", "KERN", "LUZ"),
  ext = "gpkg"
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("urban_audit",
"year",TRUE)}.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{spatialtype}{character string. Type of geometry to be returned. Options
available are:
\itemize{
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
\item \code{"LB"}: Labels - \code{POINT} object.
}}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{level}{character string. Level of Urban Audit. Possible values \code{"all"}
(the default), that would download the full dataset or \code{"CITIES"}, \code{"FUA"},
and (for versions prior to \code{year = 2020}) \code{"GREATER_CITIES"}, \code{"CITY"},
\code{"KERN"} or \code{"LUZ"}.}

\item{ext}{character. Extension of the file (default \code{"gpkg"}). One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("urban_audit",
"ext",TRUE)}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
The dataset contains the boundaries of cities (\code{"CITIES"}), greater cities
(\code{"GREATER_CITIES"}) and functional urban areas (\code{"FUA"}) as defined
according to the EC-OECD city definition. This is used for the Eurostat Urban
Audit data collection.

\strong{Please note that} this function gets data from the aggregated GISCO
Urban Audit file. If you prefer to download individual urban audit files,
please use \code{\link[=gisco_get_unit_urban_audit]{gisco_get_unit_urban_audit()}}.
}
\details{
See more in \href{https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Territorial_typologies_for_European_cities_and_metropolitan_regions}{Eurostat - Statistics Explained}.

The cities are defined at several conceptual levels:
\itemize{
\item The core city (\code{"CITIES"}), using an administrative definition.
\item The Functional Urban Area/Large Urban Zone (\code{"FUA"}), approximating the
functional urban region.
The coverage is the EU plus Iceland, Norway and Switzerland . The dataset
includes polygon features, point features and a related attribute table
which can be joined on the URAU code field.
}

The \code{"URAU_CATG"} field defines the Urban Audit category:
\itemize{
\item \code{"C"} = City.
\item \code{"F"} = Functional Urban Area Service Type.
}
}
\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
\donttest{

cities <- gisco_get_urban_audit(year = 2021, level = "CITIES")

if (!is.null(cities)) {
  bcn <- cities[cities$URAU_NAME == "Barcelona", ]

  library(ggplot2)
  ggplot(bcn) +
    geom_sf()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
See \code{\link[=gisco_bulk_download]{gisco_bulk_download()}} to perform a bulk download of datasets.

See \code{\link[=gisco_get_unit_urban_audit]{gisco_get_unit_urban_audit()}} to download single files.

Other statistical units datasets:
\code{\link{gisco_get_census}()},
\code{\link{gisco_get_coastal_lines}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()}
}
\concept{stats}
