% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star.R
\name{star}
\alias{star}
\alias{unstar}
\alias{star_check}
\title{Star a gist}
\usage{
star(gist, ...)

unstar(gist, ...)

star_check(gist, ...)
}
\arguments{
\item{gist}{A gist object or something that can be coerced to a gist object.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A message, and a gist object, the same one input to the function.
}
\description{
Star a gist
}
\examples{
\dontrun{
id <- '4ac33b9c00751fddc7f8'
gist(id) \%>\% star()
gist(id) \%>\% star_check()
gist(id) \%>\% unstar()
gist(id) \%>\% unstar() \%>\% star()
gist(id) \%>\% star_check()
gist(id) \%>\%
  star() \%>\%
  star_check()
  
# pass in a url
x <- "https://gist.github.com/expersso/4ac33b9c00751fddc7f8"
gist(x) \%>\% star
gist(x) \%>\% unstar
}
}
