% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects_and_repos.R
\name{gl_archive}
\alias{gl_archive}
\title{Archive a repository}
\usage{
gl_archive(project, ...)
}
\arguments{
\item{project}{Project name or id}

\item{...}{further parameters passed on to \code{\link[=gitlab]{gitlab()}} API call,
may include parameter \code{sha} for specifying a commit hash}
}
\value{
if save_to_file is NULL, a raw vector of the archive, else the path
to the saved archived file
}
\description{
Archive a repository
}
\examples{
\dontrun{
set_gitlab_connection(
  gitlab_url = "https://gitlab.com", 
  private_token = Sys.getenv("GITLAB_COM_TOKEN")
)
gl_archive(project = "<<your-project-id>>", save_to_file = "example-project.zip")
}
}
