% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.r
\name{gitter.batch}
\alias{gitter.batch}
\title{Process a batch set of plate images}
\usage{
gitter.batch(image.files, ref.image.file = NULL, verbose = "l", ...)
}
\arguments{
\item{image.files}{Directory containing images OR a character vector of image paths.}

\item{ref.image.file}{Specifies path to a reference image, which will be used to grid images specified in \code{image.files}.}

\item{verbose}{See parameters in \code{\link{gitter}}.}

\item{...}{Additional parameters passed to \code{\link{gitter}}}
}
\value{
\code{\link{gitter.batch}} does not return any values. DAT and gridded files are saved to their respective directories.
}
\description{
This function will process a directory or list of images in a batch.
You can also use this function to process images with sparse to empty rows/columns using a reference image.
}
\examples{
# Processing image using reference image
# This image would typically fail to process, since its missing several rows
f = system.file("extdata", "sample_dead.jpg", package="gitter")
# We will use this image to successfully process the above image
f.ref = system.file("extdata", "sample.jpg", package="gitter")
# Process
gitter.batch(f, f.ref)

# Remember: output files by default are saved to your working directory
}
\keyword{batch}
\keyword{directory}
\keyword{reference}

