% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-methods.R
\name{vcov.gkwreg}
\alias{vcov.gkwreg}
\title{Extract Variance-Covariance Matrix from a Generalized Kumaraswamy Regression Model}
\usage{
\method{vcov}{gkwreg}(object, complete = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically the result of a call
to \code{\link{gkwreg}}.}

\item{complete}{Logical indicating whether the complete variance-covariance matrix
should be returned in case some coefficients were omitted from the original fit.
Currently ignored for \code{gkwreg} objects.}

\item{...}{Additional arguments (currently not used).}
}
\value{
A square matrix with row and column names corresponding to the coefficients
in the model. If the variance-covariance matrix is not available (for example, if
the model was fitted with \code{hessian = FALSE}), the function returns \code{NULL}
with a warning.
}
\description{
This function extracts the variance-covariance matrix of the estimated parameters
from a fitted Generalized Kumaraswamy regression model. The variance-covariance
matrix is essential for statistical inference, including hypothesis testing and
confidence interval calculation.
}
\details{
The variance-covariance matrix is estimated based on the observed information
matrix, which is derived from the second derivatives of the log-likelihood function
with respect to the model parameters. For \code{gkwreg} objects, this matrix is
typically computed using the TMB (Template Model Builder) automatic differentiation
framework during model fitting.

The diagonal elements of the variance-covariance matrix correspond to the squared
standard errors of the parameter estimates, while the off-diagonal elements represent
the covariances between pairs of parameters.
}
\seealso{
\code{\link{gkwreg}}, \code{\link{confint}}, \code{\link{summary.gkwreg}}
}
