# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculates a glcm texture for use in the glcm.R script
#'
#' This function is called by the \code{\link{glcm}} function. It is 
#' not intended to be used directly.
#'
#' @export
#' @param d a matrix containing the pixels to be used in the texture
#' calculation
#' @param n_grey number of grey levels to use in texture calculation
#' @param window_dims 2 element list with row and column dimensions of the
#' texture window
#' @param shift a matrix where each row gives an (x, y) shift to use when 
#' computing co-occurrency matrices. Textures will be calculated for each 
#' shift, and the average over all shifts will be returned.
#' @param statistics a list of strings naming the texture statistics to 
#' calculate
#' @param na_opt one of "ignore", "center", or "any"
#' @param na_val what value to use to fill missing values on edges or where
#' necessary due to chosen na_opt value
#' @return a list of length equal to the length of the \code{statistics} input 
#' parameter, containing the selected textures measures
#' @examples
#' # Calculate GLCM textures on a matrix using low-level calc_texture function
#' d <- matrix(seq(1:25), nrow=5, ncol=5, byrow=TRUE)
#' calc_texture(d, n_grey=25, window_dims=c(3,3),
#'              shift=matrix(c(1,1), nrow=1), statistics=c('variance'),
#'              na_opt="any", na_val=NA)
calc_texture <- function(d, n_grey, window_dims, shift, statistics, na_opt, na_val) {
    .Call('_glcm_calc_texture', PACKAGE = 'glcm', d, n_grey, window_dims, shift, statistics, na_opt, na_val)
}

