% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_cor}
\alias{get_cor}
\alias{put_cor}
\title{translate vector of correlation parameters to correlation values}
\usage{
get_cor(theta)

put_cor(C)
}
\arguments{
\item{theta}{vector of internal correlation parameters (elements of scaled Cholesky factor, in \emph{row-major} order)}

\item{C}{a correlation matrix}
}
\value{
a vector of correlation values (\code{get_cor}) or glmmTMB scaled-correlation parameters (\code{put_cor})
}
\description{
translate vector of correlation parameters to correlation values
}
\details{
These functions follow the definition at \url{http://kaskr.github.io/adcomp/classdensity_1_1UNSTRUCTURED__CORR__t.html}:
if \eqn{L} is the lower-triangular matrix with 1 on the diagonal and the correlation parameters in the lower triangle, then the correlation matrix is defined as \eqn{\Sigma = D^{-1/2} L L^\top D^{-1/2}}{Sigma = sqrt(D) L L' sqrt(D)}, where \eqn{D = \textrm{diag}(L L^\top)}{D = diag(L L')}. For a single correlation parameter \eqn{\theta_0}{theta0}, this works out to \eqn{\rho = \theta_0/\sqrt{1+\theta_0^2}}{rho = theta0/sqrt(1+theta0^2)}. The \code{get_cor} function returns the elements of the lower triangle of the correlation matrix, in column-major order.
}
\examples{
th0 <- 0.5
stopifnot(all.equal(get_cor(th0),th0/sqrt(1+th0^2)))
get_cor(c(0.5,0.2,0.5))
C <- matrix(c(1,  0.2,  0.1,
             0.2,  1, -0.2,
             0.1,-0.2,   1),
           3, 3)
## test: round-trip (almostl results in lower triangle only)
stopifnot(all.equal(get_cor(put_cor(C)),
                   C[lower.tri(C)]))
}
