% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnetFlex.R
\name{glmnet.path}
\alias{glmnet.path}
\title{Fit a GLM with elastic net regularization for a path of lambda values}
\usage{
glmnet.path(x, y, weights = NULL, lambda = NULL, nlambda = 100,
  lambda.min.ratio = ifelse(nobs < nvars, 0.01, 1e-04), alpha = 1,
  offset = NULL, family = gaussian(), standardize = TRUE,
  intercept = TRUE, thresh = 1e-10, maxit = 1e+05,
  penalty.factor = rep(1, nvars), exclude = integer(0),
  lower.limits = -Inf, upper.limits = Inf, trace.it = 0)
}
\arguments{
\item{x}{Input matrix, of dimension \code{nobs x nvars}; each row is an
observation vector. Can be a sparse matrix.}

\item{y}{Quantitative response variable.}

\item{weights}{Observation weights. Default is 1 for each observation.}

\item{lambda}{A user supplied lambda sequence. Typical usage is to have the
program compute its own lambda sequence based on \code{nlambda} and
\code{lambda.min.ratio}. Supplying a value of lambda overrides this.}

\item{nlambda}{The number of lambda values, default is 100.}

\item{lambda.min.ratio}{Smallest value for lambda as a fraction of lambda.max,
the (data derived) entry value (i.e. the smallest value for which all
coefficients are zero). The default depends on the sample size \code{nobs}
relative to the number of variables \code{nvars}. If \code{nobs >= nvars}, the
default is 0.0001, close to zero. If \code{nobs < nvars}, the default is 0.01.
A very small value of \code{lambda.min.ratio} will lead to a saturated fit
in the \code{nobs < nvars} case. This is undefined for some families of
models, and the function will exit gracefully when the percentage deviance
explained is almost 1.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le \alpha \le 1}.
The penalty is defined as \deqn{(1-\alpha)/2||\beta||_2^2+\alpha||\beta||_1.}
\code{alpha=1} is the lasso penalty, and \code{alpha=0} the ridge penalty.}

\item{offset}{A vector of length \code{nobs} that is included in the linear
predictor. Useful for the "poisson" family (e.g. log of exposure time), or
for refining a model by starting at a current fit. Default is NULL. If
supplied, then values must also be supplied to the \code{predict} function.}

\item{family}{A description of the error distribution and link function to be
used in the model. This is the result of a call to a family function. Default
is \code{gaussian()}. (See \code{\link[stats:family]{family}} for details on
family functions.)}

\item{standardize}{Logical flag for x variable standardization, prior to
fitting the model sequence. The coefficients are always returned on the
original scale. Default is \code{standardize=TRUE}. If variables are in the
same units already, you might not wish to standardize.}

\item{intercept}{Should intercept be fitted (default=TRUE) or set to zero (FALSE)?}

\item{thresh}{Convergence threshold for coordinate descent. Each inner
coordinate-descent loop continues until the maximum change in the objective
after any coefficient update is less than thresh times the null deviance.
Default value is \code{1e-10}.}

\item{maxit}{Maximum number of passes over the data; default is \code{10^5}.}

\item{penalty.factor}{Separate penalty factors can be applied to each
coefficient. This is a number that multiplies \code{lambda} to allow differential
shrinkage. Can be 0 for some variables, which implies no shrinkage, and that
variable is always included in the model. Default is 1 for all variables (and
implicitly infinity for variables listed in exclude). Note: the penalty
factors are internally rescaled to sum to \code{nvars}.}

\item{exclude}{Indices of variables to be excluded from the model. Default is
none. Equivalent to an infinite penalty factor.}

\item{lower.limits}{Vector of lower limits for each coefficient; default
\code{-Inf}. Each of these must be non-positive. Can be presented as a single
value (which will then be replicated), else a vector of length \code{nvars}.}

\item{upper.limits}{Vector of upper limits for each coefficient; default
\code{Inf}. See \code{lower.limits}.}

\item{trace.it}{Controls how much information is printed to screen. Default is
\code{trace.it=0} (no information printed). If \code{trace.it=1}, a progress
bar is displayed. If \code{trace.it=2}, some information about the fitting
procedure is printed to the console as the model is being fitted.}
}
\value{
An object with class "glmnetfit" and "glmnet".
\item{a0}{Intercept sequence of length \code{length(lambda)}.}
\item{beta}{A \code{nvars x length(lambda)} matrix of coefficients, stored in
sparse matrix format.}
\item{df}{The number of nonzero coefficients for each value of lambda.}
\item{dim}{Dimension of coefficient matrix.}
\item{lambda}{The actual sequence of lambda values used. When alpha=0, the
largest lambda reported does not quite give the zero coefficients reported
(lambda=inf would in principle). Instead, the largest lambda for alpha=0.001
is used, and the sequence of lambda values is derived from this.}
\item{dev.ratio}{The fraction of (null) deviance explained. The deviance
calculations incorporate weights if present in the model. The deviance is
defined to be 2*(loglike_sat - loglike), where loglike_sat is the log-likelihood
for the saturated model (a model with a free parameter per observation).
Hence dev.ratio=1-dev/nulldev.}
\item{nulldev}{Null deviance (per observation). This is defined to be
2*(loglike_sat -loglike(Null)). The null model refers to the intercept model.}
\item{npasses}{Total passes over the data summed over all lambda values.}
\item{jerr}{Error flag, for warnings and errors (largely for internal
debugging).}
\item{offset}{A logical variable indicating whether an offset was included
in the model.}
\item{call}{The call that produced this object.}
\item{family}{Family used for the model.}
\item{nobs}{Number of observations.}
}
\description{
Fit a generalized linear model via penalized maximum likelihood for a path of
lambda values. Can deal with any GLM family.
}
\details{
\code{glmnet.path} solves the elastic net problem for a path of lambda values.
It generalizes \code{glmnet::glmnet} in that it works for any GLM family.

Sometimes the sequence is truncated before \code{nlambda} values of lambda
have been used. This happens when \code{glmnet.path} detects that the decrease
in deviance is marginal (i.e. we are near a saturated fit).
}
\examples{
set.seed(1)
x <- matrix(rnorm(100 * 20), nrow = 100)
y <- ifelse(rnorm(100) > 0, 1, 0)

# binomial with probit link
fit1 <- glmnet:::glmnet.path(x, y, family = binomial(link = "probit"))
}
