% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{stepCriterion.overglm}
\alias{stepCriterion.overglm}
\title{Variable selection in Negative Binomial and Beta-Binomial Regression Models}
\usage{
\method{stepCriterion}{overglm}(
  model,
  criterion = c("bic", "aic", "p-value"),
  direction = c("backward", "forward"),
  test = c("wald", "score", "lrt", "gradient"),
  level = 0.05,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{an object of the class overglm which is obtained from the fit of a negative binomial or beta-binomial model. The linear predictor of the model whose fit is stored in this overglm object is the more complex candidate which should be considered by the variable selection procedure.}

\item{criterion}{an (optional) character string indicating the criterion which should be used to compare the candidate models. The available options are: AIC ("aic"), BIC ("bic") and \emph{p}-value of the \code{test} test ("p-value"). By default, \code{criterion} is set to be "bic".}

\item{direction}{an (optional) character string indicating the mode of variable selection which should be used. The available options are: deleting variables ("backward")  and adding variables ("forward"). By default, \code{direction} is set to be "backward".}

\item{test}{an (optional) character string indicating the statistical test which should be used to compare nested models. The available options are: Wald ("wald"), Rao's score ("score"), likelihood ratio ("lrt") and gradient ("gradient") tests. By default, \code{test} is set to be "wald".}

\item{level}{an (optional) numeric value in the interval (0,1) indicating the significance level chosen to perform the statistical tests. This is only appropiate if \code{criterion="p-value"}. By default, \code{level} is set to be 0.05.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods. For example, \code{k}, that is, the magnitude of the penalty in the AIC, which by default is set to be 2.}
}
\value{
A list which contains the following objects:
\itemize{
\item{\code{initial}:}{ an expression describing the linear predictor of the "initial" model.}
\item{\code{final}:}{ an expression describing the linear predictor of the "final" model.}
\item{\code{criterion}:}{ a character string describing the criterion chosen to compare the candidate models.}
}
}
\description{
Performs variable selection in negative binomial and beta-binomial regression models.
}
\seealso{
\link{stepCriterion.lm}, \link{stepCriterion.glm}, \link{stepCriterion.glmgee}
}
