% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{vcov.glmgee}
\alias{vcov.glmgee}
\title{Estimate of the variance-covariance matrix in GEEs}
\usage{
\method{vcov}{glmgee}(object, ..., type = c("robust", "jackknife"))
}
\arguments{
\item{object}{An object of the class glmgee which is obtained from the fit of a generalized estimating equation.}

\item{...}{further arguments passed to or from other methods. For example, \code{k}, that is, the magnitude of the penalty in the QIC (or the QICu), which by default is set to be 2.}

\item{type}{an (optional) character string indicating the type of estimator which should be used. The available options are: robust estimator ("robust"), jackknife estimator computed from the one-step approximations of the ``leave-one-out'' estimates of the parameter vector ("jackknife"). By default, \code{type} is set to be "robust".}
}
\value{
A \code{matrix} with the type-\code{type} estimate of the variance-covariance matrix.
}
\description{
Computes the type-\code{type} estimate of the variance-covariance matrix from an object of the class glmgee.
}
\examples{
## Example 1
mod <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="Exchangeable")
vcov(fit1)
vcov(fit1,type="jackknife")

## Example 2
mod <- dep ~ visit + group
fit2 <- glmgee(mod, id=subj, family=gaussian, corstr="AR-1", data=depression)
vcov(fit2)
vcov(fit2,type="jackknife")

## Example 3
mod <- depressd ~ visit + group
fit3 <- glmgee(mod, id=subj, family=binomial, corstr="Stationary-M-dependent(3)", data=depression)
vcov(fit3)
vcov(fit3,type="jackknife")

}
\references{
Lipsitz S.R., Laird N.M. and Harrington D.P. (1990) Using the jackknife to estimate the variance of regression estimators from repeated measures studies. \emph{Communications in Statistics - Theory and Methods} 19, 821–845.
}
