% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.r
\name{plot_map}
\alias{plot_map}
\alias{plot_map.exp_score}
\alias{plot_map.abnorm_score}
\title{Create map for cross-sectional globaltrends data}
\usage{
plot_map(data, ...)

\method{plot_map}{exp_score}(data, type = c("obs", "sad", "trd"), ...)

\method{plot_map}{abnorm_score}(data, ...)
}
\arguments{
\item{data}{Data exported from \code{export_...} or \code{compute_abnorm} functions.}

\item{...}{Further arguments passed to or from other methods.}

\item{type}{Object of type \code{character} indicating the type of time
series-column from data_score, takes either \emph{obs}, \emph{sad}, or \emph{trd}. Defaults
to \emph{"obs"}.}
}
\value{
Map of cross-sectional data as \code{ggplot2} object.
}
\description{
The function creates world maps for cross-sectional search score data. It
uses the output of \code{export_score} to prepare a map of search scores. For
output from \code{get_abnorm_hist} the map shows abnormal changes in the
respective country search scores. When the output includes more than one
keyword, only the first keyword is used.
}
\examples{
\dontrun{
data <- export_score(keyword = "amazon")
plot_map(data, type = "obs")

data <- export_score(keyword = "amazon")
data <- get_abnorm_hist(data, train_win = 12, train_break = 0, type = "obs")
plot_map(data)
}

}
