% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlorenz.R
\name{rlorenz}
\alias{rlorenz}
\title{Compute relevant probabilities and estimates for selecting performance criteria}
\usage{
rlorenz(p, data, group, edata, newwts = "newwts")
}
\arguments{
\item{p}{percentile based on data from group with lower mean value}

\item{data}{dataset of group with higher mean value.}

\item{group}{variable of interest. Entered in quotes.Must be present in data and edata.}

\item{edata}{dataset of group with lower mean value.Must have defined newwts column. Sum of newwts for edata must be equal to sum of newwts for data.}

\item{newwts}{sampling weights. "newwts" by default. Must be present in data and edata.}
}
\value{
Relative Lorenz function value for p
}
\description{
Compute relevant probabilities and estimates for selecting performance criteria
}
\examples{

df_samp <- data.frame(x1 = rnorm(500, mean = 5, sd = 2),newwts = rep(1, 500))
df_samp2 <- data.frame(x1 = rnorm(500, mean = 4.5, sd = 2),newwts = rep(1, 500))
p_vals <- seq(0, 1, length.out = 100)
lc_vals <- rlorenz(p_vals, data = df_samp, group = "x1", edata = df_samp2)

#Creates relative Lorenz curve values for two sets of simulated data
}
