% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_functions.R
\name{variable_importance}
\alias{variable_importance}
\title{Variable Importance in BART Model}
\usage{
variable_importance(bart_model, y, x, cutoff = 0, n_repeats = 10, seed = NULL)
}
\arguments{
\item{bart_model}{A BART model object.}

\item{y}{Vector indicating presence (1) or absence (0).}

\item{x}{Dataframe with same number of rows as the length of the vector `y` with the covariate values.}

\item{cutoff}{A numeric threshold for converting predicted probabilities into presence-absence.}

\item{n_repeats}{An integer indicating the number of times to repeat the permutation for each variable.}

\item{seed}{An optional seed for random number generation.}
}
\value{
A data frame where each column corresponds to a predictor variable, and each row contains the variable importance scores across permutations.
}
\description{
This function computes the variable importance scores for a fitted BART (Bayesian Additive Regression Trees) model
using a permutation-based approach. It measures the impact of each predictor variable on the model's performance
by permuting the values of that variable and evaluating the change in performance (F-score is the performance metric).
}
