% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottobooster.R
\name{glottobooster}
\alias{glottobooster}
\title{Enhance glottolog data}
\usage{
glottobooster(
  glottologdata = NULL,
  space = TRUE,
  addfamname = TRUE,
  addisolates = TRUE,
  L1only = TRUE,
  addfamsize = TRUE,
  addfamsizerank = TRUE
)
}
\arguments{
\item{glottologdata}{data from \href{https://glottolog.org/}{glottolog}, can be downloaded with glottoget("glottolog").}

\item{space}{Return spatial object?}

\item{addfamname}{Add column with familiy names?}

\item{addisolates}{Add column to identify isolates?}

\item{L1only}{Keep only L1 languages (remove bookkeeping, unclassifiable, sign languges, etc.).}

\item{addfamsize}{Add column with family size?}

\item{addfamsizerank}{Add column with family size rank?}
}
\value{
glottologdata object, either a spatial object (class: sf) or a data.frame.
}
\description{
This function restructures glottolog data, and optionally adds/removes data. If you want more flexibility in choosing which data to add/remove, you can use glottoboosterflex().
}
\details{
This function is used to generate 'glottobase' (the reference dataset used throughout the glottospace R package). The default options generate 'glottobase', which can be loaded directly using glottoget("glottobase").
}
\examples{
\donttest{
glottologdata <- glottoget("glottolog")
glottobase <- glottobooster(glottologdata)
}
}
\seealso{
Other <glottobooster>: 
\code{\link{glottoboosterflex}()}
}
\concept{<glottobooster>}
