% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-list.R
\name{md_bullet}
\alias{md_bullet}
\title{Markdown bullet list}
\usage{
md_bullet(x, marker = c("*", "-", "+"))
}
\arguments{
\item{x}{The vector of bullet point list items.}

\item{marker}{The bullet list marker to use; one of \code{-}, \code{+}, or \code{*}.}
}
\value{
A \code{glue} vector with length equal to \code{x}.
}
\description{
take a character vector and return a glue vector of valid bullet list items.
When printed together, these bullet list items create a bullet list. This
container block is rendered as the \code{<ul>} HTML tag, with each element of the
vector creating a separate \code{<li>} tag.
}
\details{
A list is a sequence of one or more list items of the same type. The list
items may be separated by any number of blank lines.

Two list items are of the same type if they begin with a list marker of the
same type. Two list markers are of the same type if (a) they are bullet list
markers using the same character (\code{-}, \code{+}, or \code{*})...
}
\examples{
md_bullet(state.name[1:5])
md_bullet(sample(state.name, 5), marker = "+")
}
\seealso{
Other container block functions: \code{\link{md_define}},
  \code{\link{md_list}}, \code{\link{md_order}},
  \code{\link{md_quote}}, \code{\link{md_task}}
}
\concept{container block functions}
