% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/glyco.outliers.R
\name{glyco.outliers}
\alias{glyco.outliers}
\title{Discover outliers in glycan data}
\usage{
glyco.outliers(data, group = NULL, outlier.function = NULL,
  glyco.names = NULL)
}
\arguments{
\item{data}{data frame which holds columns representing Glycans.
These column names should start with 'GP'.}

\item{group}{this a possible grouping parameter on which
stratification of \code{data} should be conducted. It should be
a name of one of the columns in dataframe \code{data}
and of type \code{factor}.}

\item{outlier.function}{is a function that checks for outliers in
a vector. Receives one parameter representing a vector and returns
logical vector indicating outliers.}

\item{glyco.names}{names of columns that represent glycan data. If \code{NULL}
all columns starting with 'GP' in their names will be used}
}
\value{
Returns a data.frame with outliers
}
\description{
Returns outliers in data columns starting with GP (representing glycans)
sometimes grouped by other variables
}
\examples{
exampleData <- data.frame(ID=1:100, GP1=runif(100),
  GP2=rexp(100,0.2), GP3=rgamma(100, 3),
  Plate=factor(sample(1:2,100,replace=TRUE)))
glyco.outliers(exampleData)
glyco.outliers(exampleData, group="Plate")
}
\author{
Ivo Ugrina
}

