% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap_unique}
\alias{smap_unique}
\title{Apply Function to Unique Structures Only}
\usage{
smap_unique(.x, .f, ..., .parallel = FALSE)
}
\arguments{
\item{.x}{A glycan structure vector (glyrepr_structure).}

\item{.f}{A function that takes an igraph object and returns a result.
Can be a function, purrr-style lambda (\code{~ .x$attr}), or a character string naming a function.}

\item{...}{Additional arguments passed to \code{.f}.}

\item{.parallel}{Logical; whether to use parallel processing. If \code{FALSE} (default),
parallel processing is disabled. Set to \code{TRUE} to enable parallel processing.
See examples in \code{\link{smap}} for how to set up and use parallel processing.}
}
\value{
A list with results for each unique structure, named by their hash codes.
}
\description{
Apply a function only to the unique structures in a glycan structure vector,
returning results in the same order as the unique structures appear.
This is useful when you need to perform expensive computations but only
care about unique results.
}
\examples{
# Create a structure vector with duplicates
core1 <- o_glycan_core_1()
structures <- glycan_structure(core1, core1, core1)  # same structure 3 times

# Only compute once for the unique structure
unique_results <- smap_unique(structures, igraph::vcount)
length(unique_results)  # 1, not 3

# Use purrr-style lambda
unique_results2 <- smap_unique(structures, ~ igraph::vcount(.x))
length(unique_results2)  # 1, not 3

}
