% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDiag.R
\name{coloredBiplot.genDiag}
\alias{coloredBiplot.genDiag}
\title{Colored biplot for gemeralised diagonalisations
Colored biplot method for objects of class genDiag}
\usage{
\method{coloredBiplot}{genDiag}(x, choices = 1:2, scale = 0, pc.biplot = FALSE, ...)
}
\arguments{
\item{x}{a generalized diagonalisation object, as obtained from a call to
\code{\link{Maf}} (or to \code{UWEDGE} or \code{RJD}, on the help page of \code{\link{Maf}}).}

\item{choices}{which factors should be represented? vector of 2 indices; defaults to
c(1,2)}

\item{scale}{deprecated, kept for coherence with \code{link{biplot.princomp}}}

\item{pc.biplot}{same as the homonimous argument from \code{link{biplot.princomp}}:
boolean, to scale variables down by sqrt(n) and observations up by the same factor.}

\item{...}{further arguments to \code{\link{coloredBiplot}}}
}
\value{
nothing. Function is called exclusively to produce the plot
}
\description{
Colored biplot for gemeralised diagonalisations
Colored biplot method for objects of class genDiag
}
\examples{
data("jura", package="gstat")
juracomp = compositions::acomp(jura.pred[, -(1:6)]) 
lrvg = logratioVariogram(data=juracomp, loc=jura.pred[,1:2])
mf = Maf(juracomp, vg=lrvg)
mf
compositions::coloredBiplot(mf, xlabs.col=as.integer(jura.pred$Rock)+2)
}
\seealso{
Other generalised Diagonalisations: 
\code{\link{Maf}()},
\code{\link{predict.genDiag}()}
}
\concept{generalised Diagonalisations}
