% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostats.R
\name{gsi.CondTurningBands}
\alias{gsi.CondTurningBands}
\title{Internal function, conditional turning bands realisations}
\usage{
gsi.CondTurningBands(
  Xout,
  Xin,
  Zin,
  vgram,
  nbands = 400,
  tol = 1e-15,
  nsim = NULL
)
}
\arguments{
\item{Xout}{matrix of coordinates of locations where realisations are desired}

\item{Xin}{matrix of coordinates of locations of conditioning points}

\item{Zin}{matrix of variables at the conditioning locations}

\item{vgram}{covariogram model, of format "gmCgram"}

\item{nbands}{number of bands to use}

\item{tol}{tolerance for the inversion of the cokriging matrix (in case of near-singularity)}

\item{nsim}{number of realisations to return}
}
\value{
an array with (npoint, nvar, nsim)-elements, being npoint=nrow(X)
and nvar = nr of variables in vgram
}
\description{
Internal function to compute conditional turning bands simulations
}
