% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.R
\name{modify_message}
\alias{modify_message}
\title{Modify the labels on a message}
\usage{
modify_message(id, add_labels = NULL, remove_labels = NULL,
  user_id = "me")
}
\arguments{
\item{id}{message id to access}

\item{add_labels}{label IDs to add to the specified message}

\item{remove_labels}{label IDs to remove from the specified message}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Function to modify the labels on a given message by id.  Note you need to
use the label ID as arguments to this function, not the label name.
}
\examples{
\dontrun{
modify_message(12345, add_labels='label_1')
modify_message(12345, remove_labels='label_1')
#add and remove at the same time
modify_message(12345, add_labels='label_2', remove_labels='label_1')
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/modify}
}
\seealso{
Other message: \code{\link{attachment}},
  \code{\link{delete_message}},
  \code{\link{import_message}},
  \code{\link{insert_message}}, \code{\link{messages}},
  \code{\link{message}}, \code{\link{save_attachments}},
  \code{\link{save_attachment}},
  \code{\link{send_message}}, \code{\link{trash_message}},
  \code{\link{untrash_message}}
}

