% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.R
\name{send_message}
\alias{send_message}
\title{Send a message from a mime message}
\usage{
send_message(mail, type = c("multipart", "media", "resumable"),
  thread_id = NULL, user_id = "me")
}
\arguments{
\item{mail}{mime mail message created by mime}

\item{type}{the type of upload to perform}

\item{thread_id}{the id of the thread to send from.}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Send a message from a mime message
}
\examples{
\dontrun{
send_message(mime(from="you@me.com", to="any@one.com",
                          subject="hello", "how are you doing?"))
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/send}
}
\seealso{
Other message: \code{\link{attachment}},
  \code{\link{delete_message}},
  \code{\link{import_message}},
  \code{\link{insert_message}}, \code{\link{messages}},
  \code{\link{message}}, \code{\link{modify_message}},
  \code{\link{save_attachments}},
  \code{\link{save_attachment}},
  \code{\link{trash_message}},
  \code{\link{untrash_message}}
}

