% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignv_to_aaw.R
\name{assignv_to_aaw}
\alias{assignv_to_aaw}
\title{Assign a variable to all_apps_wide}
\usage{
assignv_to_aaw(oTree, app, variable, newvar, resafter = NULL)
}
\arguments{
\item{oTree}{A list of data frames created
with \code{\link[=import_otree]{import_otree()}}.}

\item{app}{Character string. The data frame from which the variable is taken.}

\item{variable}{Character string.
The name of the variable that should be assigned to \code{$all_apps_wide}.}

\item{newvar}{Character string.
The name of the newly created variable in the \code{$all_apps_wide} data
frame.}

\item{resafter}{Character string.
The name of the variable that precedes the new variable.
If \code{NULL}, the new variable will be placed at the end of the data frame.}
}
\value{
This function returns a duplicate of the original oTree list of
data frames but with an additional column in the \code{$all_apps_wide} data
frame that contains the variable in question.
}
\description{
Assign a variable from one of the app data frames to \code{$all_apps_wide}.
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Check out the old variable
oTree$survey$player.age

# Create a new variable
oTree$survey$younger30 <- ifelse(oTree$survey$player.age < 30, 1, 0)

# Assign the variable younger30 to all_apps_wide
oTree2 <- assignv_to_aaw(
  oTree = oTree,
  app = "survey",
  variable = "younger30",
  newvar = "younger30")

# Show the new variable in the all_apps_wide data frame
oTree2$all_apps_wide$younger30

# Check the position of the new variable
match("younger30",names(oTree2$all_apps_wide))

# Place the new variable immediately after the "survey.1.player.age" variable
oTree2 <- assignv_to_aaw(oTree,
                        app = "survey",
                        variable = "younger30",
                        newvar = "younger30",
                        resafter = "survey.1.player.age")

# Show the new variable in the all_apps_wide data frame
oTree2$all_apps_wide$younger30

# Show the position of the new variable
match("younger30", names(oTree2$all_apps_wide))
}
