% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{change_regime}
\alias{change_regime}
\title{Change regime parameters \strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}
  of the given parameter vector}
\usage{
change_regime(p, M, d, params, m, regime_pars)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{number of time series in the system, i.e. the dimension.}

\item{params}{a real valued vector specifying the parameter values.
\describe{
  \item{\strong{For unconstrained models:}}{
    Should be size \eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
    ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
    \itemize{
      \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
      \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
      \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
    }
  }
  \item{\strong{For constrained models:}}{
    Should be size \eqn{((M(d+d(d+1)/2+1)+q-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\psi}}
    \eqn{,\sigma_{1},...,\sigma_{M},\alpha_{1},...,\alpha_{M-1})}, where:
    \itemize{
      \item \strong{\eqn{\psi}} \eqn{(qx1)} satisfies (\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}
      \strong{\eqn{\phi}}\eqn{_{M}) =} \strong{\eqn{C \psi}}. Here \strong{\eqn{C}} is \eqn{(Mpd^2xq)}
      constraint matrix.
    }
  }
}
Above, \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of the \eqn{m}:th
mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component, and
\eqn{\alpha_{m}} is the mixing weight parameter.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks columns
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.
The notation is in line with the cited article by \emph{Kalliovirta, Meitz and Saikkonen (2016)} introducing the GMVAR model.}

\item{m}{which component?}

\item{regime_pars}{a size \eqn{((pd^2+d+d(d+1)/2)x1)} vector
\strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m,0},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}.}
}
\value{
Returns parameter vector with \code{m}:th regime changed to \code{regime_pars}.
}
\description{
\code{change_regime} changes the regime parameters (excluding mixing weights parameter)
  of the pointed regime to the new given parameters.
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
 }
}
