% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printMethods.R
\name{print.gmvarsum}
\alias{print.gmvarsum}
\title{Summary print method from objects of class 'gmvarsum'}
\usage{
\method{print}{gmvarsum}(x, ..., digits)
}
\arguments{
\item{x}{object of class 'gmvarsum' generated by \code{summary.gmvar}.}

\item{...}{currently not used.}

\item{digits}{the number of digits to be printed.}
}
\description{
\code{print.gmvarsum} is a print method for object \code{'gmvarsum'} generated
  by \code{summary.gmvar}.
}
\examples{
# This example uses the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(2,2), d=2 model
params222 <- c(-11.904, 154.684, 1.314, 0.145, 0.094, 1.292, -0.389,
 -0.070, -0.109, -0.281, 0.920, -0.025, 4.839, 11.633, 124.983, 1.248,
  0.077, -0.040, 1.266, -0.272, -0.074, 0.034, -0.313, 5.855, 3.570,
  9.838, 0.740)
mod222 <- GMVAR(data, p=2, M=2, params=params222, parametrization="mean")
sumry222 <- summary(mod222)
print(sumry222)
}
