% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMethod.R
\name{predict.gmvar}
\alias{predict.gmvar}
\title{Predict method for class 'gmvar' objects}
\usage{
\method{predict}{gmvar}(
  object,
  ...,
  n_ahead,
  n_simu = 2000,
  pi = c(0.95, 0.8),
  pi_type = c("two-sided", "upper", "lower", "none"),
  pred_type = c("median", "mean", "cond_mean"),
  plot_res = TRUE,
  mix_weights = TRUE,
  nt
)
}
\arguments{
\item{object}{an object of class \code{'gmvar'}, generated by function \code{fitGMVAR} or \code{GMVAR}.}

\item{...}{additional arguments passed to \code{grid} (ignored if \code{plot_res==FALSE}) which plots
grid to the figure.}

\item{n_ahead}{how many steps ahead should be predicted?}

\item{n_simu}{to how many independent simulations should the forecast be based on?}

\item{pi}{a numeric vector specifying the confidence levels of the prediction intervals.}

\item{pi_type}{should the prediction intervals be "two-sided", "upper", or "lower"?}

\item{pred_type}{should the prediction be based on sample "median" or "mean"? Or should it
be one-step-ahead forecast based on the exact conditional mean (\code{"cond_mean"})?
Prediction intervals won't be calculated if the exact conditional mean is used.}

\item{plot_res}{should the results be plotted?}

\item{mix_weights}{\code{TRUE} if forecasts for mixing weights should be plotted,
\code{FALSE} in not.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction (ignored if \code{plot_res==FALSE}). Default is \code{round(nrow(data)*0.15)}.}
}
\value{
Returns a class '\code{gmvarpred}' object containing, among the specifications,...
 \describe{
   \item{$pred}{Point forecasts}
   \item{$pred_int}{Prediction intervals, as \code{[, , d]}.}
   \item{$mix_pred}{Point forecasts for the mixing weights}
   \item{mix_pred_int}{Individual prediction intervals for mixing weights, as \code{[, , m]}, m=1,..,M.}
 }
}
\description{
Forecast GMVAR process defined as a class \code{'gmvar'} object. The forecasts are
  computed by performing independent simulations and using the sample medians or means as point
  forecasts and empirical quantiles as prediction intervals. For one-step-ahead predictions
  using the exact conditional mean is also supported.
}
\examples{
# GMVAR(2, 2), d=2 model
params22 <- c(0.36, 0.121, 0.223, 0.059, -0.151, 0.395, 0.406, -0.005,
 0.083, 0.299, 0.215, 0.002, 0.03, 0.484, 0.072, 0.218, 0.02, -0.119,
  0.722, 0.093, 0.032, 0.044, 0.191, 1.101, -0.004, 0.105, 0.58)
mod22 <- GMVAR(gdpdef, p=2, M=2, d=2, params=params22)
p1 <- predict(mod22, n_ahead=10, pred_type="median", n_simu=500)
p1
p2 <- predict(mod22, n_ahead=10, nt=20, lty=1, n_simu=500)
p2
p3 <- predict(mod22, n_ahead=10, pi=c(0.99, 0.90, 0.80, 0.70),
              nt=30, lty=0, n_simu=500)
p3

# Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
params22s <- c(0.36, 0.121, 0.484, 0.072, 0.223, 0.059, -0.151, 0.395,
 0.406, -0.005, 0.083, 0.299, 0.218, 0.02, -0.119, 0.722, 0.093, 0.032,
 0.044, 0.191, 0.057, 0.172, -0.46, 0.016, 3.518, 5.154, 0.58)
W_22 <- matrix(c(1, 1, -1, 1), nrow=2, byrow=FALSE)
mod22s <- GMVAR(gdpdef, p=2, M=2, params=params22s, parametrization="mean",
 structural_pars=list(W=W_22))
p1 <- predict(mod22s, n_ahead=10, n_simu=500)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
 @keywords internal
}
\seealso{
\code{\link{GIRF}}, \code{\link{GFEVD}}, \code{\link{simulateGMVAR}}
}
