% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit2xtab.R
\name{xtable.joint}
\alias{xtable.joint}
\title{Print an LaTeX-ready \code{xtable} for a \code{joint} object.}
\usage{
\method{xtable}{joint}(
  x,
  caption = NULL,
  label = NULL,
  align = NULL,
  digits = NULL,
  display = NULL,
  auto = FALSE,
  p.val = FALSE,
  max.row = NULL,
  dp = 3,
  vcov = FALSE,
  capture = FALSE,
  capture.location = "",
  hlines = "middle-bottom",
  booktabs = TRUE,
  size = "footnotesize",
  ...
)
}
\arguments{
\item{x}{a joint model fit by the \code{joint} function.}

\item{caption}{character, specifies the \code{caption} argument of \code{xtable}. By default
this takes value \code{NULL}, which results in a generic caption being generated.}

\item{label}{character, specifies the \code{label} argument of \code{xtable}.}

\item{align}{character, specifies the \code{align} argument of \code{xtable}. Note by default
this is \code{NULL}, as alignment is done internally.}

\item{digits}{integer, specifies the \code{digits} argument of \code{xtable}. Note by default
this is \code{NULL}, as argument \code{dp} controls this (but can be specified through this, 
too).}

\item{display}{character, specifies the \code{display} argument of \code{xtable}.}

\item{auto}{logical, specifies the \code{auto} argument of \code{xtable}. Defaults to 
\code{FALSE}. Not recommended to change.}

\item{p.val}{logical, should p-values be returned? Defaults to \code{p.val = FALSE}.}

\item{max.row}{integer, the number of rows after which the table is `broken' vertically
and merged horizontally; useful for long tables. Defaults to \code{max.row = NULL} which
results in one long table. Note that this can be quite finicky, so trial and error may be 
required.}

\item{dp}{integer, the number of decimal places to round the estimate, standard error and
confidence intervals to; defaults to \code{dp = 3}.}

\item{vcov}{logical, should the half-vectorisation of the block diagonal of covariance 
matrix be reported? Default is \code{vcov = FALSE}.}

\item{capture}{logical, should the printed \code{xtable} output be saved anywhere instead
of just printed to the console? Defaults to \code{capture = FALSE}.}

\item{capture.location}{character, if \code{capture = TRUE}, this should specify what
\emph{file} it should be saved in. Defaults to \code{capture.location = ""}.}

\item{hlines}{character, specifies which horizontal lines are used in the outputted
LaTeX table. Supply a character string which contains \code{"top"}, \code{"middle"} and/or
\code{"bottom"} (in any order) to specify a \code{toprule}; \code{midrule} and 
\code{bottomrule} in the table. If \code{booktabs = FALSE}, then these will simply 
be \code{hline}s. For instance \code{hlines = "top-middle-bottom"} prints all three;
whilst \code{hlines = "middle-bottom"} skips the \code{toprule}.}

\item{booktabs}{logical, if \code{booktabs = TRUE} (the default) then \code{toprule};
\code{midrule} and \code{bottomrule} replace the usual \code{hline}s.}

\item{size}{character, LaTeX size to be placed before the tabular environment, defaults
to \code{size = "footnotesize"}; replace with \code{"normalsize"} if wanted.}

\item{...}{additional arguments, none used.}
}
\value{
A LaTeX-ready \code{xtable} print-out of the joint model. A list containing 
constituent tables is also returned invisibly, along with the final \code{xtable} output.
}
\description{
Prints an \code{xtable} output for a fitted \code{joint} object to the console,
or to a specified save location
}
\examples{
# Bivariate joint model ------------------------------------------------
require(xtable)
data <- simData(n = 100)$data
long.formula <- list(
  Y.1 ~ time + cont + bin + (1 + time|id),
  Y.2 ~ time + cont + bin + (1 + time|id)
)
surv.formula <- Surv(survtime, status) ~ cont + bin
family <- list("gaussian", "gaussian")
fit <- joint(long.formula, surv.formula, data, family)
xtable(fit)
# Example of arguments: add dummy caption, add p-values.
xtable(fit, p.val = TRUE, dp = 4, caption = "This is a caption")
# Change size, place horizontal lines everywhere
xtable(fit, size = "normalsize", hlines = c("top-middle-bottom"))
# Make a wider table without booktabs 
xtable(fit, booktabs = FALSE, max.row = 6)
}
\seealso{
\code{\link{joint}}
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
